package org.msh.tb.bd.dashboard.query;

import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.Workspace;
import org.msh.utils.date.DateUtils;

import javax.persistence.EntityManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by mauri on 20/05/2017.
 * Service that queries database for dashboard indicator detailed and summary result
 */
public abstract class IndicatorQuery {

    private EntityManager entityManager;
    private Workspace workspace;
    private AdministrativeUnit selectedAdminUnit;
    private Date iniDate;
    private Date endDate;

    /**
     * @param o single result returned from database
     * @return the rate calculated
     */
    public abstract Float calculateRate(Object[] o);

    /**
     * @param adminUnitCondition
     * @return the database result
     */
    protected abstract List<Object[]> getQueryResult(String adminUnitCondition);

    /**
     * @return The result used by IndicatorParser to create the dashboard summarized report.
     */
    public List<Object[]> getSummaryResult(){
        List<Object[]> ret;

        if (getSelectedAdminUnit() != null) {
            // create administrative unit condition
            String auCondition = "and au.id = " + getSelectedAdminUnit().getId();
            ret = includeRate(getQueryResult(auCondition));
        } else {
            // this will return the result for first level of admin unit
            List<Object[]> results = getDetailedResult();

            ret = new ArrayList<Object[]>();
            // get root result
            ret.add(results.get(results.size()-1));
        }

        return ret;
    }

    /**
     * @return The result used by DetailedIndicator to mount the detailed reports.
     */
    public List<Object[]> getDetailedResult(){
        // create administrative unit condition
        String auCondition;

        if (getSelectedAdminUnit() != null) {
            auCondition = "and au.code like '" + getSelectedAdminUnit().getCode() + "%' ";
            int level = getSelectedAdminUnit().getCountryStructure().getLevel() + 1;
            auCondition += "and au.countryStructure.level = " + level;
        } else {
            auCondition = "and au.countryStructure.level = 1 ";
        }

        //get database result and include for each result its rate
        List<Object[]> ret = includeRate(getQueryResult(auCondition));

        // calculate root
        long rootNum1 = 0;
        long rootNum2 = 0;

        for (Object[] o : ret){
            if (o[1] != null) {
                rootNum1 = rootNum1 + (Long) o[1];
            }

            if (o[2] != null) {
                rootNum2 = rootNum2 + (Long) o[2];
            }
        }

        Object[] root = new Object[] {"root", rootNum1, rootNum2, null};
        root[3] = calculateRate(root);

        ret.add(root);

        return ret;
    }

    /**
     * @param result
     * @return The same result list including the rate as one more item in Object array
     */
    protected List<Object[]> includeRate(List<Object[]> result) {
        List<Object[]> newResult = new ArrayList<Object[]>();

        for (Object[] o : result) {
            Object[] newObj = new Object[]{o[0], o[1], o[2], calculateRate(o)};
            newResult.add(newObj);
        }

        return newResult;
    }

    public EntityManager getEntityManager() {
        return entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public Workspace getWorkspace() {
        return workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public AdministrativeUnit getSelectedAdminUnit() {
        return selectedAdminUnit;
    }

    public void setSelectedAdminUnit(AdministrativeUnit selectedAdminUnit) {
        this.selectedAdminUnit = selectedAdminUnit;
    }

    public Date getIniDate() {
        return iniDate;
    }

    public void setIniDate(Date iniDate) {
        this.iniDate = iniDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getIniYear() {
        if (iniDate == null) {
            return null;
        }

        return DateUtils.yearOf(iniDate);
    }
}
